#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200005;
const int SIZ = 32;

int A[MAXN];
int B[MAXN];
int prefs[MAXN];

unordered_map<int, int> mapi;

int sparse[SIZ][300000];

struct Node {
	int value = 0;
	int deca[2] = {-1, -1};
	int age[2] = {-1, -1};
};
Node nodes[SIZ * MAXN];
int node_index;

int last_reset[SIZ];


int newNode() {
	node_index++;
	nodes[node_index].value = 0;
	nodes[node_index].deca[0] = -1;
	nodes[node_index].deca[1] = -1;
	nodes[node_index].age[0] = -1;
	nodes[node_index].age[1] = -1;
	return node_index;
}

void insert(int root, int age, int prefix) {
	int temp = root;

	for (int i = SIZ-1; i >= 0; i--) {
		bool bit = prefix & (1 << i);

		if (nodes[temp].deca[bit] == -1) {
			nodes[temp].deca[bit] = newNode();
		}
		nodes[temp].age[bit] = age;
		temp = nodes[temp].deca[bit];
	}

	nodes[temp].value = prefix;
}

int queryAnti(int root, int age, int prefix) {
	int temp = root;

	for (int i = SIZ-1; i >= 0; i--) {
		bool bit = prefix & (1 << i);

		if (nodes[temp].deca[1-bit] != -1 && nodes[temp].age[1-bit] >= age) {
			temp = nodes[temp].deca[1-bit];
		}
		else if (nodes[temp].deca[bit] != -1 && nodes[temp].age[bit] >= age) {
			temp = nodes[temp].deca[bit];
		}
	}

	return mapi[nodes[temp].value];
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);

	int n;
	cin >> n;

	for (int i = 1; i <= n; i++) {
		cin >> A[i];
	}
	for (int i = 1; i <= n; i++) {
		cin >> B[i];
		sparse[0][i] = B[i];
	}

	for (int k = 1; (1<<k) < n; k++) {
		for (int i = 1; i <= n; i++) {
			sparse[k][i] = sparse[k-1][i] & sparse[k-1][i + (1 << (k-1))];
		}
	}

	// for (int k = 0; (1<<k) < n; k++) {
	// 	for (int i = 1; i <= n; i++) {
	// 		cout << sparse[k][i] << " ";
	// 	}
	// 	cout << endl;
	// }


	node_index = 0;
	for (int k = 0; k < SIZ; k++) {
		last_reset[k] = -10;
		newNode();
		insert(1, 0, 0);
	}

	int prefix = 0;
	long long ans = LONG_LONG_MIN;
/*	for (int i = 0; i < n; i++) {
		prefix ^= A[i];
		insert(root, prefix);

		ans = max(ans, queryAnti(root, prefix));
	}
*/


	for (int i = 1; i <= n; i++) {
		prefix ^= A[i]; 
		prefs[i] = prefix;
		mapi[prefix] = i;
		insert(1, i, prefix);

		unordered_set<int> calculated;

		for (int k = 0; k < SIZ; k++) {
			bool bit = B[i] & (1 << k);
			if (bit == false) {
				last_reset[k] = i;
			}
			if (calculated.find(last_reset[k]) != calculated.end()) {
				continue;
			}
			int j = queryAnti(1, last_reset[k], prefix);
			int valA = prefs[i] ^ prefs[j];

			int L = j+1;
			int R = i;
			int valB = 0;
			if (L == R) valB = B[L];
			else if (R > L) {
 				int stepen = (int)log2(R - L + 1); 
				valB = (sparse[stepen][L] & 
					sparse[stepen][R - (1 << stepen) + 1]);
			}
			long long temp = (long long)valA * valB;
			ans = max(ans, temp);


			calculated.insert(last_reset[k]);

		}
	}

	cout << ans << endl;

	return 0;
}